<?php
/*
Plugin Name: Elfsight Instagram Testimonials CC
Description: Let real Instagram testimonials increase trust in your brand
Plugin URI: https://elfsight.com/instagram-testimonials-widget/wordpress/?utm_source=markets&utm_medium=codecanyon&utm_campaign=instagram-testimonials&utm_content=plugin-site
Version: 1.3.1
Author: Elfsight
Author URI: https://elfsight.com/?utm_source=markets&utm_medium=codecanyon&utm_campaign=instagram-testimonials&utm_content=plugins-list
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');
require_once('api/elfsight-api.php');
require_once('includes/api.php');

$elfsight_instagram_testimonials_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_instagram_testimonials_config = json_decode(file_get_contents($elfsight_instagram_testimonials_config_path), true);

if (is_array($elfsight_instagram_testimonials_config['settings'])) {
    array_push($elfsight_instagram_testimonials_config['settings']['properties'], array(
        'id' => 'api',
        'name' => esc_html__('Custom API Url'),
        'tab' => 'more',
        'type' => 'hidden',
        'defaultValue' => admin_url('admin-ajax.php')
    ));
}

new ElfsightInstagramTestimonialsApi(
    array(
        'slug' => 'elfsight-instagram-testimonials',
        'plugin_file' => __FILE__,
        'cache_time' => 21600,
        'editor_config' => &$elfsight_instagram_testimonials_config
    )
);

new ElfsightInstagramTestimonialsPlugin(array(
        'name' => esc_html__('Instagram Testimonials'),
        'description' => esc_html__('Let real Instagram testimonials increase trust in your brand'),
        'slug' => 'elfsight-instagram-testimonials',
        'version' => '1.3.1',
        'text_domain' => 'elfsight-instagram-testimonials',
        'editor_settings' => $elfsight_instagram_testimonials_config['settings'],
        'editor_preferences' => $elfsight_instagram_testimonials_config['preferences'],
        'script_url' => plugins_url('assets/elfsight-instagram-testimonials.js', __FILE__),

        'plugin_name' => esc_html__('Elfsight Instagram Testimonials'),
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),

        'menu_icon' => plugins_url('assets/img/menu-icon.png', __FILE__),
        'update_url' => esc_url('https://a.elfsight.com/updates/v1/'),

        'preview_url' => plugins_url('preview/index.html', __FILE__),
        'observer_url' => plugins_url('preview/instagram-testimonials-observer.js', __FILE__),

        'product_url' => esc_url('https://codecanyon.net/item/instagram-testimonials-plugin-for-wordpress/21382477?ref=Elfsight'),
        'support_url' => esc_url('https://elfsight.ticksy.com/submit/#100012000'),
    )
);

?>
